//
//  AnimatedLifeView.h
//  NanoLife
//
//  Created by Scott Stevenson on 2/9/08.
//  Source may be reused with virtually no restriction. See License.txt
//

#import <Cocoa/Cocoa.h>


@interface AnimatedLifeView : NSView {

    NSUInteger countOfSpheresToGenerate;
    NSGradient* backgroundGradient;
    CGPoint mouseDownPoint;
    CALayer* containerLayerForSpheres;
    NSColor* sphereCoreColor;
    NSColor* sphereGlowColor;
	
	BOOL	fixingCulling;
}

// public properties which could be used for bindings, though
// changing these values won't result in a redraw in the current
// implementation (for performance reasons).
@property NSUInteger countOfSpheresToGenerate;
@property (copy) NSGradient* backgroundGradient;
@property (copy) NSColor* sphereCoreColor;
@property (copy) NSColor* sphereGlowColor;
@property BOOL fixingCulling;

- (IBAction)fixCulling:(id)sender;

@end

